/***************************************************************
 * Name:      complex_setMain.h
 * Purpose:   Defines Application Frame
 * Author:    Petar ()
 * Created:   2025-01-28
 * Copyright: Petar ()
 * License:
 **************************************************************/

#ifndef COMPLEX_SETMAIN_H
#define COMPLEX_SETMAIN_H

#include <wx/wx.h>
#include <complex>
#include <set>
#include <vector>

struct ComplexComparator {
    bool operator()(const std::complex<double>& a, const std::complex<double>& b) const {
        if (a.real() != b.real()) return a.real() < b.real();
        return a.imag() < b.imag();
    }
};

class ComplexSet {
public:
    using SetType = std::set<std::complex<double>, ComplexComparator>;

    bool Add(const std::complex<double>& elem);
    bool Remove(const std::complex<double>& elem);
    bool Contains(const std::complex<double>& elem) const;
    void LoadFromFile(const wxString& filename);
    void SaveToFile(const wxString& filename) const;
    std::vector<std::complex<double>> GetElements() const;
    void GetBounds(double& reMin, double& reMax, double& imMin, double& imMax) const;
    bool IsEmpty() const;

private:
    SetType elements;
};

//(*Headers(complex_setFrame)
#include <wx/button.h>
#include <wx/frame.h>
#include <wx/gbsizer.h>
#include <wx/listbox.h>
#include <wx/menu.h>
#include <wx/panel.h>
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/statusbr.h>
#include <wx/textctrl.h>
//*)

class complex_setFrame: public wxFrame
{
    public:

        complex_setFrame(wxWindow* parent,wxWindowID id = -1);
        virtual ~complex_setFrame();

    private:

        //(*Handlers(complex_setFrame)
        void OnQuit(wxCommandEvent& event);
        void OnAbout(wxCommandEvent& event);
        void OnPanelPaint(wxPaintEvent& event);
        void OnListBox1Select(wxCommandEvent& event);
        void OnListBox2Select(wxCommandEvent& event);
        void OnClose(wxCloseEvent& event);
        void OnNewSet1(wxCommandEvent& event);
        void OnSaveSet1(wxCommandEvent& event);
        void OnDeleteSet1(wxCommandEvent& event);
        void OnNewSet2(wxCommandEvent& event);
        void OnSaveSet2(wxCommandEvent& event);
        void OnDeleteSet2(wxCommandEvent& event);
        void OnSet1Select(wxCommandEvent& event);
        void OnSet2Select(wxCommandEvent& event);
        void OnNew1Click(wxCommandEvent& event);
        void OnSave1Click(wxCommandEvent& event);
        void OnDelete1Click(wxCommandEvent& event);
        void OnNew2Click(wxCommandEvent& event);
        void OnSave2Click(wxCommandEvent& event);
        void OnDelete2Click(wxCommandEvent& event);
        void OnImText1Text(wxCommandEvent& event);
        void OnReText1Text(wxCommandEvent& event);
        void OnImText2Text(wxCommandEvent& event);
        void OnReText2Text(wxCommandEvent& event);
        //*)

        //(*Identifiers(complex_setFrame)
        static const long ID_STATICTEXT1;
        static const long ID_RETEXT1;
        static const long ID_STATICTEXT2;
        static const long ID_IMTEXT1;
        static const long ID_NEW1;
        static const long ID_SAVE1;
        static const long ID_DELETE1;
        static const long ID_STATICTEXT3;
        static const long ID_RETEXT2;
        static const long ID_STATICTEXT4;
        static const long ID_IMTEXT2;
        static const long ID_NEW2;
        static const long ID_SAVE2;
        static const long ID_DELETE2;
        static const long ID_LISTBOX1;
        static const long ID_LISTBOX2;
        static const long ID_DRAWPANEL1;
        static const long ID_MENUITEM1;
        static const long idMenuAbout;
        static const long ID_STATUSBAR1;
        //*)

        void UpdateSet1ListBox();
        void UpdateSet2ListBox();
        std::vector<std::complex<double>> GetIntersection() const;
        ComplexSet set1;
        ComplexSet set2;

        // Dragging
        bool isDragging;

        wxPoint dragStartPos;
        wxPoint panOffset;

        void OnMouseDown(wxMouseEvent& event);
        void OnMouseUp(wxMouseEvent& event);
        void OnMouseMove(wxMouseEvent& event);
        void Redraw();
        void RedrawListbox();

        //(*Declarations(complex_setFrame)
        wxButton* Delete1;
        wxButton* Delete2;
        wxButton* New1;
        wxButton* New2;
        wxButton* Save1;
        wxButton* Save2;
        wxListBox* Set1;
        wxListBox* Set2;
        wxPanel* DrawPanel;
        wxStaticText* StaticText1;
        wxStaticText* StaticText2;
        wxStaticText* StaticText3;
        wxStaticText* StaticText4;
        wxStatusBar* StatusBar1;
        wxTextCtrl* ImText1;
        wxTextCtrl* ImText2;
        wxTextCtrl* ReText1;
        wxTextCtrl* ReText2;
        //*)

        DECLARE_EVENT_TABLE()
};

#endif // COMPLEX_SETMAIN_H
